<?php
if ( ! empty( $customer_info ) ) :
    $customer_name  = ! empty( $customer_info['name_field'] ) ? esc_html( $customer_info['name_field'] ) : '';
    $customer_email = ! empty( $customer_info['email_field'] ) ? esc_html( $customer_info['email_field'] ) : '';
    $customer_phone = ! empty( $customer_info['phone_field'] ) ? esc_html( $customer_info['phone_field'] ) : '';

    dokan_get_template_part(
        'quote-heading', '', [
            'quote'                => $quote,
            'updated_by'           => 'Vendor',
            'converted_by'         => 'Vendor',
            'back_to_quotes'       => dokan_get_navigation_url( 'requested-quotes' ),
            'request_quote_vendor' => true,
        ]
    );
    ?>
    <div id='customer-info-container'>
        <?php if ( ! empty( $customer_name ) ) : ?>
            <div class="customer-name info-field">
                <div class="icon">
                    <svg width="19" height="22" viewBox="0 0 19 22" fill="none">
                        <path d="M9.06956 10.4872C10.4973 10.4872 11.7335 10.0036 12.7438 9.04937C13.7538 8.09533 14.2661 6.92799 14.2661 5.57939C14.2661 4.23125 13.754 3.06376 12.7437 2.1094C11.7333 1.15551 10.4972 0.671875 9.06956 0.671875C7.64163 0.671875 6.40563 1.15551 5.39546 2.10955C4.38529 3.0636 3.87305 4.2311 3.87305 5.57939C3.87305 6.92799 4.38529 8.09548 5.39546 9.04953C6.40596 10.0034 7.64213 10.4872 9.06956 10.4872ZM6.28958 2.95385C7.0647 2.2218 7.97397 1.86595 9.06956 1.86595C10.165 1.86595 11.0744 2.2218 11.8497 2.95385C12.6248 3.68606 13.0018 4.54497 13.0018 5.57939C13.0018 6.61412 12.6248 7.47287 11.8497 8.20508C11.0744 8.93729 10.165 9.29313 9.06956 9.29313C7.9743 9.29313 7.06503 8.93713 6.28958 8.20508C5.5143 7.47303 5.13736 6.61412 5.13736 5.57939C5.13736 4.54497 5.5143 3.68606 6.28958 2.95385Z" fill="#FFF"/>
                        <path d="M18.1624 16.3395C18.1333 15.9424 18.0744 15.5093 17.9876 15.052C17.9001 14.5912 17.7873 14.1556 17.6523 13.7575C17.5127 13.346 17.3233 12.9396 17.0887 12.5502C16.8456 12.146 16.5599 11.794 16.2392 11.5044C15.9039 11.2014 15.4934 10.9578 15.0187 10.7801C14.5456 10.6034 14.0214 10.5138 13.4605 10.5138C13.2403 10.5138 13.0273 10.5992 12.616 10.8521C12.3628 11.008 12.0667 11.1884 11.7362 11.3878C11.4535 11.5579 11.0707 11.7172 10.5978 11.8615C10.1364 12.0025 9.66793 12.074 9.2054 12.074C8.74319 12.074 8.27473 12.0025 7.81302 11.8615C7.34061 11.7174 6.95758 11.558 6.67545 11.388C6.34805 11.1904 6.05177 11.0101 5.79482 10.8519C5.38381 10.599 5.17081 10.5137 4.95057 10.5137C4.38961 10.5137 3.86551 10.6034 3.3926 10.7803C2.91822 10.9577 2.50753 11.2013 2.17191 11.5046C1.85126 11.7943 1.56551 12.1461 1.32256 12.5502C1.08833 12.9396 0.898704 13.3458 0.759121 13.7576C0.624311 14.1558 0.511558 14.5912 0.423989 15.052C0.337079 15.5087 0.278315 15.942 0.249181 16.3399C0.22054 16.7291 0.206055 17.134 0.206055 17.5432C0.206055 18.6068 0.564066 19.4679 1.27005 20.103C1.96731 20.7296 2.88974 21.0474 4.01184 21.0474H14.4003C15.522 21.0474 16.4445 20.7296 17.1419 20.103C17.848 19.4684 18.2061 18.607 18.2061 17.543C18.2059 17.1325 18.1912 16.7275 18.1624 16.3395ZM16.2702 19.2378C15.8094 19.652 15.1978 19.8533 14.4001 19.8533H4.01184C3.21401 19.8533 2.60235 19.652 2.14179 19.238C1.68995 18.8318 1.47037 18.2773 1.47037 17.5432C1.47037 17.1614 1.4837 16.7844 1.51037 16.4225C1.53638 16.0674 1.58954 15.6774 1.66839 15.2629C1.74625 14.8536 1.84534 14.4695 1.96319 14.1217C2.07627 13.7882 2.23051 13.4581 2.42178 13.14C2.60432 12.8368 2.81435 12.5768 3.04612 12.3672C3.2629 12.1712 3.53614 12.0107 3.8581 11.8904C4.15587 11.7791 4.49051 11.7182 4.85379 11.709C4.89806 11.7312 4.97691 11.7737 5.10464 11.8523C5.36455 12.0123 5.66413 12.1948 5.99531 12.3946C6.36863 12.6194 6.8496 12.8224 7.42423 12.9976C8.01169 13.177 8.61085 13.2681 9.20556 13.2681C9.80027 13.2681 10.3996 13.177 10.9867 12.9977C11.5619 12.8222 12.0427 12.6194 12.4165 12.3943C12.7554 12.1897 13.0466 12.0124 13.3065 11.8523C13.4342 11.7738 13.5131 11.7312 13.5573 11.709C13.9208 11.7182 14.2554 11.7791 14.5533 11.8904C14.8751 12.0107 15.1484 12.1713 15.3652 12.3672C15.5969 12.5766 15.807 12.8367 15.9895 13.1401C16.1809 13.4581 16.3353 13.7884 16.4483 14.1216C16.5663 14.4698 16.6655 14.8538 16.7432 15.2628C16.8219 15.678 16.8752 16.0682 16.9012 16.4226V16.423C16.9281 16.7835 16.9416 17.1603 16.9417 17.5432C16.9416 18.2774 16.722 18.8318 16.2702 19.2378Z" fill="#FFF"/>
                    </svg>
                </div>
                <div class="title">
                    <h3><?php esc_html_e( $customer_name, 'dokan' ); ?></h3>
                    <label><?php esc_html_e( 'Customer', 'dokan' ); ?></label>
                </div>
            </div>
        <?php endif; ?>
        <?php if ( ! empty( $customer_email ) ) : ?>
            <div class="customer-email info-field">
                <div class="icon">
                    <svg width="25" height="25" viewBox="0 0 25 25" fill="none">
                        <path d="M4.41211 4.17188H20.4121C21.5121 4.17188 22.4121 5.07187 22.4121 6.17188V18.1719C22.4121 19.2719 21.5121 20.1719 20.4121 20.1719H4.41211C3.31211 20.1719 2.41211 19.2719 2.41211 18.1719V6.17188C2.41211 5.07187 3.31211 4.17188 4.41211 4.17188Z" stroke="#FFF" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M22.4121 6.17188L12.4121 13.1719L2.41211 6.17188" stroke="#FFF" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <div class="title">
                    <h3><?php esc_html_e( $customer_email, 'dokan' ); ?></h3>
                    <label><?php esc_html_e( 'Email', 'dokan' ); ?></label>
                </div>
            </div>
        <?php endif; ?>
        <?php if ( ! empty( $customer_phone ) ) : ?>
            <div class="customer-phone info-field">
                <div class="icon">
                    <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.3759 14.6483V17.3581C19.3769 17.6096 19.3254 17.8586 19.2246 18.0891C19.1238 18.3196 18.976 18.5265 18.7907 18.6965C18.6053 18.8666 18.3865 18.9961 18.1482 19.0767C17.9099 19.1573 17.6574 19.1872 17.4068 19.1645C14.6274 18.8625 11.9576 17.9128 9.61185 16.3916C7.42946 15.0048 5.57917 13.1545 4.19239 10.9721C2.66589 8.61576 1.71592 5.93295 1.41944 3.14103C1.39687 2.89125 1.42655 2.63951 1.5066 2.40184C1.58665 2.16416 1.71532 1.94576 1.8844 1.76053C2.05348 1.57531 2.25928 1.42732 2.48869 1.32599C2.7181 1.22465 2.9661 1.1722 3.21689 1.17196H5.92662C6.36497 1.16765 6.78993 1.32287 7.1223 1.60871C7.45466 1.89454 7.67175 2.29148 7.7331 2.72554C7.84747 3.59271 8.05958 4.44416 8.36537 5.26365C8.4869 5.58694 8.5132 5.93829 8.44116 6.27607C8.36912 6.61386 8.20176 6.92391 7.95891 7.16949L6.8118 8.31661C8.09761 10.5779 9.96994 12.4502 12.2312 13.7361L13.3784 12.5889C13.6239 12.3461 13.934 12.1787 14.2718 12.1067C14.6096 12.0347 14.9609 12.061 15.2842 12.1825C16.1037 12.4883 16.9551 12.7004 17.8223 12.8148C18.2611 12.8767 18.6618 13.0977 18.9482 13.4357C19.2347 13.7738 19.3869 14.2054 19.3759 14.6483Z" stroke="#FFF" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <div class="title">
                    <h3><?php esc_html_e( $customer_phone, 'dokan' ); ?></h3>
                    <label><?php esc_html_e( 'Phone', 'dokan' ); ?></label>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
