<?php
namespace Jet_Engine_Dynamic_Charts\Admin\Pages;

use Jet_Engine\Query_Builder\Manager as Query_Builder;
use Jet_Engine_Dynamic_Charts\Admin\Dashboard;
use Jet_Engine_Dynamic_Charts\Plugin;
use Jet_Engine_Dynamic_Charts\Chart;

class Edit extends \Jet_Engine_CPT_Page_Base {

	/**
	 * Page slug
	 *
	 * @return string
	 */
	public function get_slug() {
		if ( $this->item_id() ) {
			return 'edit';
		} else {
			return 'add';
		}
	}

	/**
	 * Page name
	 *
	 * @return string
	 */
	public function get_name() {
		if ( $this->item_id() ) {
			return esc_html__( 'Edit Chart', 'jet-engine' );
		} else {
			return esc_html__( 'Add New Chart', 'jet-engine' );
		}
	}

	/**
	 * Returns currently requested items ID.
	 * If this funciton returns an empty result - this is add new item page
	 *
	 * @return [type] [description]
	 */
	public function item_id() {
		return isset( $_GET['id'] ) ? esc_attr( $_GET['id'] ) : false;
	}

	public function get_chart_types() {
		return apply_filters( 'jet-engine/dynamic-charts/charts-types', array(
			array(
				'id'    => 'bar',
				'name'  => __( 'Bar', 'jet-engine' ),
				'image' => 'iVBORw0KGgoAAAANSUhEUgAAAOYAAACRCAIAAABYL1OVAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6QjM5QjEyMDZEODI0MTFFQkE2RTRENDcxMkUzMjdBNDAiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6QjM5QjEyMDdEODI0MTFFQkE2RTRENDcxMkUzMjdBNDAiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpCMzlCMTIwNEQ4MjQxMUVCQTZFNEQ0NzEyRTMyN0E0MCIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCMzlCMTIwNUQ4MjQxMUVCQTZFNEQ0NzEyRTMyN0E0MCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PqCmIhwAAAGcSURBVHja7NzBCcIwFIBhle7hEF0hIwScpFM4ScERHCFLZI8e6jv2UC9KSPX7wAH6/Amh8Hoex7GUcoKDuBgBkgXJgmSRLLQwvH5pqgbRv+f9aghOWSQLkgXJIlmQLEgWyYJkQbJIFiQLkkWyIFmQLJIFyYJkkSx0KdYV7cFxsGTzvPzGwzxug3/UxQAkC5JFsiBZkCySBcmCZJEsSBYkC5JFsiBZkCySBcmCZJEsNBf7fbb8cMqCZEGySBYkC1vxriBN1SD4RMvPujllcTEAyYJkkSxIFiSLZEGyIFkkC5IFySJZkCxIFsmCZEGySBb6E+uKLXfN4AvJ5nn5k6f19TEXA5AsSBbJgmRBskgWJAuSRbIgWZAskgXJgmSRLEgWJItkQbIgWYiNU3unOGVBsiBZJAuSha14V5CmahDv+dKeUxYki2RBsiBZJAuSBckiWZAsSBbJGgGSBcmCZJEsSBYki2RBsrAv1hXt4nGwZPO8GAR7evtkm4sB7rIgWZAskgXJgmSRLEgWJItkQbIgWSQLkgXJIlnoxirAAH1zHHVWs07VAAAAAElFTkSuQmCC',
			),
			array(
				'id'    => 'line',
				'name'  => __( 'Line', 'jet-engine' ),
				'image' => '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',
			),
			array(
				'id'    => 'area',
				'name'  => __( 'Area', 'jet-engine' ),
				'image' => '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',
			),
			array(
				'id'    => 'pie',
				'name'  => __( 'Pie', 'jet-engine' ),
				'image' => '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',
			),
			array(
				'id'    => 'donut',
				'name'  => __( 'Donut', 'jet-engine' ),
				'image' => 'iVBORw0KGgoAAAANSUhEUgAAAOYAAACRCAYAAADXTcTCAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MEZGMjUxNkJEODI2MTFFQkExQjRFRkM2QjdBNTAwRjUiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MEZGMjUxNkNEODI2MTFFQkExQjRFRkM2QjdBNTAwRjUiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDowRkYyNTE2OUQ4MjYxMUVCQTFCNEVGQzZCN0E1MDBGNSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDowRkYyNTE2QUQ4MjYxMUVCQTFCNEVGQzZCN0E1MDBGNSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Por7ZEQAAB1ZSURBVHja7F0HdFzVmf7ee9NHM+rdXe5FNi6AbYqBAMZZioGEgIFsdpPdE3aTk012T5JNliSb5IQkJ9mTcrKcJGQhpC2EdgAbCM244IaxsZGL5CJbsqw+0khTX9n73zcCwxoi2bJ135v7nfPOjMbjKXf+7/7l/kWxLKsPo48IuxRISLgfFrvio/2iCiOmJddWQkIsqHIJJCQkMSUkJCQxJSQkMSUkJCQxJSTcC49cAmcgrYMH5lW2leoGMJAGMlnwQ6k0u/VqQFHQwsGWFH9OacSDaFiBR1OR0S1Q8N2rKQgFNPaYXE9JTImRk5ARLZEBsoyA8RTQPQB0xYFBRkbdBExGUDrkMq13n19VBNTXWvj5Uz1obMmiMKxygvo8CsJBFYUhDYUFKorDGqLsdlyZB3U1PoQDKmrLvHLRJTEl3g/SgCdiQIoRrD8BnOwHOhkRM0xLqkwjKop9eyqUU/4eIio9Rq+VypjQNFvDEnc7+wz271n+HPqbtKfBnkfPmVbrQ/2UAKay28KQiunjfagplUSVxMxTJJlGPNELdDBt2Muujn5bIxK5fOxX8TBtFxgmP4bIS2CWKzNVFW62fjDsfyOiHjqRxe7DaejM3J1Q4eUErSn1MC3qwZIZQcyc4Jc/liSmu2GYtlm6v41pxT6bnGSqEpn87JcoCJzfz0NkDvgUdtlOZzxpYuPeBDONLZRENDy1KY5idjt7oh83Xxpl5q/X1sQSkphuQB8zT491M+3UYd/P5vxE0oqRgDif0+9V2KXlzGsLrd06jrRn0dCcwXPbB5nJSwSNYHKVD1UlUnQkMR0KCtgc6QSaOkgbgUdDSUvxW9EFQ1P4Fc75sCm2m7zekMT6txKMmB5cMT+M1ZdFUVkkRUgS0yHoZoTc0wK09NoaMugjbeTc70M+rMr9Vtv0benU8Yune/EqI+m1i8O46ZIoigukjSuJKSj6mVbcc9zWkn1Jm4xkqrqtfCfkV/l1+EQWP32iF+u2DmLFBSFu5lYVy4iuJKYgoGMNCugQKengnzTMUCDHjTV1Q98pGlZhMn/5aEcWDz3fhw1vJfEPHy3CivkhKKosx5XEHEMc7wF2HrWjrGTqkZbMJ5GkJIZoSOV+aEtnFl/5dQcn5qdWFsmjFknM849UBni9CTjYbv8d9LpTO47ED/Uz/5OuddsHsaMxhVsvi+Cz15dIYZHEPD+go4/NjUD3oE1IOvaQbSDeRVWJhoGkifuf7sVbh9L414+Xoa5G+p4j2ujkEgwfZK5tPQS8vM8O7hT47eQAScr3rRPzO8N+lSfSb25I4kv3n8SzW+NyYSQxRx+ULvfsbuCNZlvwAlIBfCisnP9ZXqihM6bjmw914cePdvE8XglJzFEB5bESKY91vaslJYaPUEBFUYGKX62N8eBQLG7IRZE+5tlh3wmmJY/YxyDR4LulVhIj0J65NaPyspd2DiKdsfC1NWUYVy7NDqkxzwBEyI2NQDJrZ+9IUp49ygttv/MbD3aisSUtF0QSc2SgIM+Oo8xszZVhSYySwOX8Tio1+9bDXXizMSUXRRJzeNjCSPnGUTtZQPqT5wYlERUHWzP47u+7sGlvQi6IJOZfIWWTnckT8skZD+cS5BYUBlU0dzBy/qEL698alIsiiXl6bD8M7DpmH4UokpXnHOSyF4bpOMWwNefbUnNKYr4PlID+ZrPtT0rz9fyCGofFEyZ+8Kcu7G+WPqckZg6UYkc+JRUwS1KODQqYWXuy18CP/tyDwZRMQsh7MYwx12ZTo93uwyNJOXZmLbNrI4ycW/Ylcd8fuyQx8/nLU9/WVw/Y5KR+VPKYcuxBnRDWbh3Aw3+JSWLm6w69gZGytddOHpAQA7whmE/Bgy/0YfuBlCRmvoE61lGTLH4sIiOw4myY5G8GVPQPmvjRI90YTBqSmPkCapC16aBd3KtJUgoHOuOkBISG5hR++Eh+BoPyjpjkV25uAlK6fTQi/UoxQc2xy4s8eG77AJ7YGJfEdDuaTtptJSndzpKsFBp8ZguT0Aefj2HHwYQkpltB7SV3HssN4JFy7wiQv3myV8cvnopxv1MS04V485jtX/pltYij/M0KZtJSFcq2/QlJTLehtQdoPClJ6URQNhYNM/rzhjh68qT7QV4Qk3r0UCcCmh0ppyk7D+R60NSxbfuT2NWUQipjSWK6ARTsOdQpEwmcTk5K2fvNczEMpk1JTKeDpjRTfaXMg3WBSaspONyWwcs7B5nvaUliOl1bdg24v2rEyo17p7mWpksVipobZf/U5rjrzVnXE5MCPiSobkm7oyglJUmQJUCd++gIiC6qjqHNh75r74CBlq4sTvboPFiSZKafWxRM2K+gsSWDxzb0u1puFctyr03Q0mN3TSdBdropS4RM60AgNxK+MGi30xwaYlQYAkpCJnYeTPIGyxbbibr7dbR16Wg6kUFTawaGqSAcUOD1KI7dqOhzd/cbqJ/sx/c/U4lKl062djUxX9hjJ6qHHTp0isw2skqJQ9Roeu54oCJiJ96H/LZp915z1mKC+94HSYMe78gwLWqisTWNF5l/duB4BumsxTSswgfROhHUjuRzq4vx6VXFrpRd157q0Zh16qDutNaTRBPdtLUjDb0tCQOza4Cqor8+lkE5jRqklLaJVT5MZPcXTA1g5YUR7G9O439f7ceeI2l09uk82uljWtQpOzR9TR9bi52NKfQNGrxvkCSmQ0CkjCUoxO4sUlJzacLMKmDOOKYho6P7HkTCJTOD/Np1KMkHzq7fnUCA+W6U/uaEptZk40XZ99jLNpaTPZKYjgFpm+Zu2/9yGinJV7xwMjCl4ty/54K6IBbcE8QTG/vxwLoY2rp1lEQ1RwSKaGJ1OmViz+EkplR7ud/sJrgyKtveZwd+nGLGUokTRVinVQI3XHB+SHkqVl8Sxf1fqMaVF4TQ1WcgazjDqKVOBy/uTLiyXtN1xKTdvjvunDpL8iezTMMvmgRcMcsO7IwFaMDP9z5diZuWF3BBz+iW8JFbCn41d2QRGzBcd3brOmKSoB/vEf94hGQ+mxMmIuRFdWN/1urRFHzj7gr87TVFyGQtvmGITE6VfTiKLpOPnMqakpgigw7eY0nx6y3JWvSy1b98OjC9WqzP9s83leDuqwsRT5o2OUUVXrZ+NFJ+Z1MKIb8qiSkymtptn00R+JtR5JMmVC+aCEytEvMz3nNjCdZcFWXkFNvnJHOWspyOd2YkMUVGe799MC/qLk8+cIKRcsEEO2FAZHzx1lJcsSAkdA1k0KfwaPKmvUlJTAgs9MmM2L18Msw0rC0Blk51xpr+x53lmF8X4AEhEf1NqjihliP7jmXgpiQ2VxGzI860Ucb2PUQ1Yb0em5ROqXahw/t/urGYN2I2BI2vhIMqDp1I86MeSUwB0dZr+26iRmRJWy5kfmVl1FnretHMIG6+NMqT40XUmhRNjg2YzM/UJTFFBJEyI2iInypcygqAGdXOW1fKwV25pAC1ZV4+Lk+05fVqYH6wid4BSUwhQal4qqBRH/J9KQIb8DpzbaeP8+GaRWH2PUyIZtHaGtNAKi19TCFJGU+JacbSWSBpy0mlzl7j65dFMLHCxwuvhRNklTK+pI8pHHoH7HxTTcBCA0pOH1dqJ6g7GdNqfVxzUhBItACo36OgtSvLNkFLElMkECnJXBTNlCUhprpKp2vLISydHeRnh6IRk6pLOmIGvyQxBYKVM2dFczEpd7eEmbHjXULMZXNCPP1NtC51nJi9OuIJSUzhCMBnkgjGTBrzVxxyz1SxwgIVk6u9wp1pUgCI+hu5pemaa4iZyYpnxtJGQUEJag/iljLegE/FkhlBGILlz1LCRn/S4umYkpgCgSKyomX8WDmBIVPWLaDNj2tMAU0ACvy192QlMYV0NAUU5IKgq1YZZVFNSM1Ea93VL31MocCbSAloL/KObi7rFRXwq4gGFeG0JrkO4YAqiSnSD2IIWOpFn8uvuW9IrsK+WEWxB7qIZ4Yy+COWttQtMXNkwwG4Dh7mOFuCxplVl4RlXWPKivpzuHHAD5FSF7RYwC1tLF1BTIp8Uo6saNkoJCIDKfcRk3f2M8QTHvr5/V5IYgpFTk3AzgWK3QnPdNl0GMqu0Q0BR6hRIbomgz/SlB0m0ll3EdOrKeiNm8IVDFjSlBXTnBURdKTQ764+UTwnlawAESngdcnQD9cQk2ZGipa/SYJLxzg9g+4hJSWv7zmagUfEs1lLElPInVI4F1Ox/cteFxEzkbLw9pEUTxoXb9MAn/kpiSmSKQs7V1a0ABAnZgLCdpgbKfoHaYy8LlzBAK1zKGCPTJDEFOmLKFTFLp7WpDEIXQP2ZGs3YO22AfQnTOE0UzpjYXKVl8//lMQUCEUhIOwTTzORFk9ngNYe568xWSNbGpJIZcWbBEaackq1D1UlXklMkUD9dHgASMDigqAfONYNdPY7e403vZ3A0fYsAgIeSVD3PhpgG/BJH1MoUJQw7LezUkQDmbPU85bMWScnG6xjZmxHTOcDY0XzL+n8sjTqngHprqrHFNHHJBGmvYL6EdHAI6cGDXc1pfDa7gQfmSAaaJZnbakHBSFFElNUPzPoE0srESEp84fmlVw0xcKbRw3HaU3qI/vAc71IsFsRTUXyL2sYMWeO80tiiojqYtucFSEAREnedNWyz3TDBRZKwyYe327gwdcMNLQ46+zk+e2D2LgngZKoJuQktRTzL2l8A9WIusY1cxMxqRtd0Av0J2AfbI6B2Zo27FKv0jAwdxwFpSxsPmhg22ELsQRVwShY95aJmbWq8OPoCc3tGfx6XS8iQTFJyRueKQrfNNwE1w2uDfnGrughnrY3hovqgCtmWWiLGfjFX3S8ut/i2pM2DtLohzpM/G4DZbaLbdPSeeVXH+jAiW4dPq+Y/ptuWLyl5oQKr6vk2OM2Yo4rAVp77YDL+dh1SFyptCvFeDanFpg/3kJLj4lfvmIyAtqtK2mzQI6GtGlEAwq2H7UQDRq4eYlHyGxw8tvufbADDUczKCsUVxtRU7DSqIrZE3ySmCJjSjnwxlF7kM+5ZiYdzZDZWszIt6qejkRMPLnDZGaryUujyiOnD0RRZDbkU/BigwXNY+DGhWIJfn/CwLd/14nNe5MoiYhtIqbZrlgW9WFKjSSm2F+IyVFpAXAidm54OaQh+U5dQBqSEhssbDtk4PUm5kcO0t8KL0P7oOirlSMn+UeURdPQqmNWjUeIbJpkxsJPHu/Bi28kUFSgiVmAngOtL0WJl80NCplUL4l5CogQNCeEMm3oYH80ZYqIQ61CfB7bj6wutHCwzWSaz+SEJLINZ6IXvU5X3MLKehU1RcA/PpDGlXN0fOV6Px/YM1agidH3PtiJNxpTKGakFLEo4D3EZMwsCGr4yKKw28TYfcQk0CxKIo+J0XHfiEh0BBNP2pHWucyX7Bkw8fvNBiOmxTXkcAfS0mt1D1hYOk1lPqmCz/82xUfHPbJFR1vMxJc/6kdd1fk3H99sSuEbzKeklLuKImeIBbkS8+t8qC5xnxgrlmVZbvtSRKINB4D9bXbCwdm+FkVUy6PAogl8n8bmJhObDppMmyiIBEemVUjjzhmnYMUsBV94OIX2PgsVUYUTlu7XFiu4Y5kXH7/YyzaXc689T/Zk8YeX+vDMlgH0DTJ/rdDDvrP4IkHr1RM38PPPVWHp7JDriOlKjUnmbE0x8Hbrmf/o5ENSpLUsAsyuIS1sYfsR5kc2WuhmZmgkqIyoMx+ZudRiZGaNimXTgG8+lkYHI2JloWInRLDXKY8o6GLa9CfPZ/HKPh13MoIun+E5JwQl7j27JY5fPtPL6ytptF5pVHMEKbkvnLb4IN06lwV9XE1MQmWhTaq+pJ1DOxIQgeg8cuEkYHKZhePdFn6z3mAazS7jKgor7wRxhktK6mIwuZxpypnAz17I4GiXhbKo8p4sJXo9OkohDU3ZQV//cwYXTtGxaoEX06tVTCw7u3DWiV6T+d4mXtqjo7RQwyz2erFBA0G/wi+npAoOacu7PlLoGLNbEjOHQmZiVkVH1taDjj5oLPu0CqB+gsV8SguPbjW45qXEgIDvzISoL0EmqobVixX89IU03mw2Ef0AE5geosgyRRnp37ceYkRqSKGuQsXSqRrqKomgCuaN1+AfxqH/8R4Tu9n7Hek0sfGAjv2tJhSVfG8dD94TwnWLQ3hic4LtXs75bSlpnbT7BdMDbhVf9xKTMG880BoDEhlqufjhfiR1sytiZLl0hsX8UosJsYnX2JXRlbMaPEvlXrUlCj6xFPjVyxms32dwk3W4pCYfmc48O/ot/HZjlpvPVUUK155lEftY5p1Xyx3B0N90S5vM0S6TR44zPPNI4VqaNDi93pPbsli1JIoNe1P82MYp/XJ6mba87qICXFAnielI0FxKMmkPnaatB4kgRfUyOngAZ1olMKkMTJvZfmRbL43PU7imPJPwGJEqkbbf/9YlKh7ZksW63cyELLCJMZKXpOdS1DdQaJubNAt0+2GDm7wf9Nno/el96P+V5N7zVP+SSL2WfZ7ViwNMwP14jZFTc4C7Rj4w1V7Om+x3TQ/ZvCMmYUYV0xqd7x0DTzekRclkrGdadRp7zvFuA7951eQa1sP9yBwpzpCUyYxt/t6yWMNLb2fxxHYdJWFbw52NKzdEtsBZ5q4quWvtbhOrL4ti3fZBhNgLm4I7mhT0qSn14rL6sKvlVnU7MUljjS95t7MByV0f0zhV7PHrF9CtgccZae5/yeRNsyiv1ec5O4Gn+ksi55plKrYdzuJ/XssiHFDsA3tB1mVozseGA8w8ZndWzA/xDngiw8xNZbjz6qjrktbzTmOSb7lgop0JRH5WgH3jlfOocZfFTFYD6/ebzL9SuNk7Gie69B4kPHczUh5oM/DjtVl+tCKi+0aWQXufiQ2NCu64MoK1TGsWCNpljpYvlTUxn/mVNyyNuF1s3a8xCRVRYHo1MLWCkbKe/Edmtr6m47k99hjqwuDokJJeg3Z18ilbe01858kMQv7hZwWNycbFdoznd2cQjgZxw8VhtLO1EXG8npkbTvyZVUUI+lVJTLfgkukUlTTwy5d1PLbD5B3riJC+UeoTRGYqHc1cN19FnPlB33kqzVP1zjR4dL4QYp+v6aSBHc3AtYvDfD1E6zRIG0VHn4GVS8KYMymQF/KaN8QkU7K520Jzl8WT20dTi6m5dLrLZ6lM0C385+MpfsbISe+AQ/uyiIqH16cweXwBls7yI5YQh5mkvOMJExPKPbj9qkLXtKeUxDwF19V7UD9BHdWxeMS7nkFGypkaZtVY+NojKX4u6nXQylLA6xjbtNYfMLHq4gLezdwUZEfRmQ1LXQpuWh7BzPH+vJHVvCImabDVizREQnZi+mhgIAksn65hbq2Frz+S5gkFZMI6qTKA/LfqIgV/fD2NqRPCmFLpEaaj/WDSYuarH3ddXZRPoppfxCRQJ70VM1XeVvJsghwqT7UDFk5WMW+chR88k0H3gJ1d48R6HTrT7WOff8thC7deHkUsbnC/eUw3DNP+XHd9pChvTNi8JSZ1VCMNt2CCgp6BM5vBMZSUPqtWwdKpFn76QgbNPZad/+rQdbEsOxd47S4Dk2uDzGz0IZWxxvB3YhvFoIGLZwddWQgtiXkaUKT0hkUqP0ahtLmRgjTl9GoFH12g4L9fzGJ3s8UHGjm9sJW007FOHXvaVHzymijae/QxOTqht4wNmpg72Y8v31aWjyKan8QkVEZVXFuv8eT1kfibA4zIUysV3LRIwa9fyWD9fmNY7UScgKH84ed2ZTFtYghLZgTQGzfPKznpvahtZlFYw7/cUorKEo8kZr7h0hkaFk5SeMuQ4QgMFU5TAfaNjJS/20RJ6QbKChS4qQ9UmPlyu47qaOrWcNOyMDJZk/t652tjoDEMlKj+hVtKsGBqIG9lM6+JSbjtQuZvEjlTHzzwhx6mKhQqnr51iYYnd+g8Kb08Klb+66gIhGqvw6ObM5g/PYL5U/xs4zo/zKToMI2S/+LHSrHqooK8lsu8JyaVdt25TGPmqd254HTI8PIqC2uWq3i1IYuHNmR5KZX7uiXZoA4NrzfqONyjYOWS0IhaqJwpLO5XGvjUtYW448rCfBdLSUxCYUjBx5jmrClWuA95qgyS/0kH3Hct15iJZ+BnL2T5890cvFcUe03+sDGNJbMjqC09t72AiPRU/HzNojD+flWxFEhJzHcxvlRlvqPKRxpQLeUQ6P4tF3rQ2G7g+89kUMy0CZVLWS5eCyIKTeduaLVwvE/BNYvDGEydu/Hu1L9nzkQfPnt9McIBKZKSmO/D3HEqrwyJBOx2IzSd64ZFGnoHGCmfzqCi0Dn5r6NBTiqRo9GBl82PIMo06LlIbqdxDBMqPPjqHeWYUOmTQiiJeXrMn6jh4xdpPLXuylkKWyADP3w2w7vXKXm2Fh5GzL3HdbTGNdy+IoqOvtE51xzqSTSQNDGl2ov7Pl2B2RP9UvgkMT8cCyaquHe1hpDfxLceT/Mesx4tD4WDMYhM2Of3ktYMM4tB4609ztZ/zegWYswKWTwjiO/+XQVmTQxIoZPEHB6qi1SURlTeJT2ZsfJ2HWiWyoZ9WfTpPtx6SQG6+89ca/KzYLaW3f0G/ubiAvz77aWoq5GaUhJzhFg2zYOffyqIK+doaOm1M2DyzZylZtn9CQvP7srikvowNz2TafOMSEkzWuLMp7znhmL8222lqCnzSCGTxDwzjCtW8cM7AvjMFT70Dlq8V2s+gWwFSqR4fGsGli+AFfMCZ1TPOmQCf/OT5bjnxhKEAxryb5uTxBxV0BDaL63y44vX+XkrjhgjaD6JlJbLBnpkSwZXL4ny5IrhnmtSOh/5k2VRDV9fU46blkff0aASkpijgjXLvfj2LX5Mq1KZaWvxFLJ8EDAr1yD6L3t0qD4fFk4L/NWjEzXnT7b16Jg1wYd77yrLy/KtM4Urx/Cda5zsM3HfU2leWUKTuCLB/DjbJDP+2novrp9r4O77TqC27P93Ohjap9pjTEsWqriZacgbL4lgfLlXCo4k5vnB2l1Z/HZDFk0dJoJeBV6Pu70mIiFtRN+7zYs/Pd+NV/ckURRS38mCIgsilTH5865aGMYnLo+ivk4ehUhijgF64hYe3ZbF49uzvCkXNZimIUBuXVSaXHbHpQFcPimDu77fhppSO7JKneyoMoVmVt5yWQRXXVAgbPNoScw8whGmNe9/KY1NBw3E00BpeOTDg5yABPMbSwpU/GhNAA893YFHNw7wrnpE0GsWF+D2K6KoKJbHIJKYgmH9Ph1/fD2LrU0GP5wPujD9sy1m4fPXBTC9MIEv/6oLl8wL454bi7m2pKFEqipDrpKYAoKKqulo4dldOg53mFxQycQdOnZwso9JfmR/0uJVNv+1xo+QR8fkKnePxJPEdBlaeqjzu4Hn3tL5PEtq/JVIW3yEnt8hQUoSDip9o5pU6pdLyfwrZmtYOs2DukoN5RH5O0tiOhSUa0tBk8e2Z/HGERNHuky0x+x2l2G/XbUi0o9AZ7OUGECakfocjS9VMKVC5T2SVtZ7eZvLs53PKSGJKQxI6yhM6l9pyGLbIRM7mBZtOGHy1h3UUpOaGnvGMJBJ3RpoExlI2dU0CyepWDBRw3JGyAuneJBlJrpXxnUkMd2OhhYDhztNHkyh+/tO0PBce+iRxpzRoXHtam78M9dRZ5hIP/QrW7n75CsO3dJ8ELpfU6Ridq2KWewqjyiYN15DbYk88pDEzGN09pk8Sb4vZWE/I+hbx0wc6jCZ9rJ40rjBZ29a/NYw3h1dT6Tltyq4NrZMO1XwVOJp6tBlH+FouWln1HRrepWKueM0zKxR+XCh8qjK+/1ISGJKvA9p3eJBIop0tvWY2HnUQDfTpH3M56MeuIPs3yjyS6YnFR3TfUqXI1OZMnOIdNQChe6TSUotQnjgJqggwm6rihRcWKdxAlIpVjSojvmcEglJTFeBCDzALtK2qYzdRIsIR0SUARpJTAkJiVGENGAkJCQxJSQkJDElJCQxJSQkRguUx9Evl0FCQiz8nwADAEjScasO5jZPAAAAAElFTkSuQmCC',
			),
			array(
				'id'    => 'bubble',
				'name'  => __( 'Bubble', 'jet-engine' ),
				'image' => 'iVBORw0KGgoAAAANSUhEUgAAAOYAAACRCAIAAABYL1OVAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RTQyMDg2MDREODI1MTFFQjk0QjA4MUIwN0Q1RkQwNEQiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RTQyMDg2MDVEODI1MTFFQjk0QjA4MUIwN0Q1RkQwNEQiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpFNDIwODYwMkQ4MjUxMUVCOTRCMDgxQjA3RDVGRDA0RCIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpFNDIwODYwM0Q4MjUxMUVCOTRCMDgxQjA3RDVGRDA0RCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PqvK5pQAABoDSURBVHja7J1pcBTXncD79TXdPfehGd0XugCBQAIbEM4BPnA2W47ZWlOEsqt2/cXlLymnnHxaYqqIv7hS5cTrZO0PrsouxTr2rsmS1DqYxHhjwOBY3BI60C2NRsfcPdPTd+8bDciSEGAdI43E+9UUTL/p482bn/79f328BoZhYKuEYDDo8XhWS20vXbrU1NS0VGuLRqMXro784apzzk//vjF0erxoVGQXsGYnp3o5bZ93aGdj/apoWBJD5DyiKF5rn9tXK4t//1Hcai/Z6zHP+kjWsBsB3WrCtpcQbjOgcEzVsYmEEZfSQUpWsSsjWnfQKHPQW4owi7k8GuMdditSFrEEdNwa+Lxz7gha4AINVVa7hdl610dQ2d0VhscMCDCt1Hf7f7hzrfLgpzrV5xqoChecg14trYEjIXKceDwejKkjUWbOT22MBgDW2dm5ZcsWMI3jx4/DsOqzgItfnJ8qfOmll1KpVCgUOnjwYFdXZ50X37+JLHWA8+fPZz7SNA0pi1gsPX1D/9duudenVrOm6Okf8cknnxQEwbjDoUOHoMrQxaNHj8I+QKbwsccee+WVVziOO3LkyHvvvacrqWoPHo2Ejh079vrrr2MEPRHhkbKIRcHzfCRhhJL33GvbWVU15v4RYdQ8efLkr371K7fbnSnZv39/UVERNLu2trahoeHEiROw8De/+c3zzz9vc7hvBsTA2ARSFrEoQuFoZ2CGr9tr2R/stu5/zJZ5ee2aPvkjnj59GobPqRwAxleoJkwqph9jYVn28OHD0GDNSOvb29sLZ7NYLLuam7uC+l+6dVkUkLKIxSo7GPo6i3VY8MYa5skmyxNN5syLIkkMgLsTg+bm5unrmUp24b/wfUrBSJp97rnn3n777RdeeCGYNM7c0m6MkZIGcv+gJwkTnVX0E66i2paVlS2ytoqihBMgyEMj1UyJphKGbsA9/o9//Mq7774LS05+fNruzptzcRh0bTYbrAMMqzATuHr1Klzwtddegx+JiqFoadFLSkoYlrsZ0m+OaS4qBX0dGxsjyZw+jkSuooPzD9upBLhbByA8XSCCxAEOVTOgix0dHVDEnuExjqHm3J3DNOCZZ5750Y9+dPz48Uw6Ozg4eO3atbT60H2cmj4zjNQ+RtJ1ANcMXUeJAWIhqKoqyg/4gRxmhsSMu3PZzEErmB7A7tfevXszhQcOHHjrrbeg6BhB3b0qH5NSdQBDe64nBsiMnAXaM5kVzB2A6+rq4Jtnn332t/9xLLPfnzWPbmC8qNfM/Ah21jqDBnztKMHhUm+88cZk7po+HOs1iUIKKYtYBDCz5EVizo+mEgOYfsAuWkhhjfQO05AkmaIoGFChiFDFy/1xgmLqC00MmS6JS8aX/akPPmt9dGNZgdUbEzFVM6DE/WFdUTTo+EiU0nUdKYtYaNKG4w5Ovf88MF3+5S9/Wbft22eEzXAyEJiwWq0sZ4EumigQCCSsVvC30elpgKmhoaHH73//mqzqRJjX4JyQg2WDV3rMjWWpHO97oVw2p4Hx0mu/3wyiDDv+2NNPP91243oNNZz20WTieZ7AMeirKIqJRAIqCHPi3t5eODm1IE3T8O8hHYknj2g1ukIRnhiNmThahxtFURaxcGVp4n4n/WNJPRhT19fU5re0eIF/BLgwlysQCMBsITMDzBwYJn1Yt7CwEFoLO2SZpKKiogIAXFJ1TTcspPKoK/jBl+nrZUykhpRFLByz2WwxSXeXsywLu03wzWhYvdIteuzkoUOHYChlr3efixZiBWmmZpaU9MkBE8Ns2LBhWpaMCZKeTOl5JvEJr//3XzlgIYEbDKVlFEfKIhYC7EUxrKXIIfrvXMaVkozhCYVN79Whd9hETO0flc9eT9ZXmAgCePPKvoX19SQslxKFUErdgJmDnkjp8L2ZwTnT5FKTBw1S0FdRb/aMV5tjp687BdmAGWyZSzRbbLnfLEjZnMaX56z0hqeUhSHzfy8mMCwxfR5/UP30SvLOlHNjqfD9/JsfDZdG5K/jJRQUvqYm7ZT0TxWDvRPsyY7MqZl0J686X/Tl5SNlEYvCbrfnO0LzWqRtkBsap79VEah0pcZFZlxixkQmkGLzGdHHpLzpf8W+CPvXNntEmJG25tmBw+FAyiIWhclkKspja/OTnaPmb75UXCQ/b3ecA3a3RXFa1BIrX26NwzwhFCEv8eZQ0qHps89QNJUlirzW26kDUhaxYERRdDnMu6qGBoImUZ3fj6UbYIKn4asr8MB5jS0l8fKy6lXRJkjZHEVV1bauXkGUw7rVpDFPNMT6x0w3hi3Z2NYjFUlfQeFqaRmkbC6iKEpLa/en4eK4dvuiKkFIbXWM1eOJ1sEltjbfLm2t0EqKClZL46CzX7nI1db2U6HyKV+x9MWv7JWEl7WA9YXJJdwQTerf2xwpL81fRY2DlM05xsfHbwmulD77fi+WZS8nfbUFAgBLdeOA8Q/bIls216+u9kHK5hwRXoipc9yfCABgOZal9XybtPituMzKi7sDu7bV5f4ZWpTLrgyapgmT6LoO4yXHcTQ9932zqmbI+tzXHEJrVYL93ubY6TZjKMwuuDI1vtTuWmFbY9NqbEmkbHYJhULDgXAqJQBMm+CpUIJKyni+LeS1qTRhAJLxeeylJTN6624b6x4X/MrcR/VtINHU2GizD46MB892WUeipnnVp9QlfquW93qc1evqV2mTgpaWFiRWloinwFCI7A9SE3GSF2fnYCZSz7NpTrO2s0rEAJycFmh17Ji/5u4VbrBEttqDNH47lxUVEIjgPeN07zglKvfL8Thar/QqVT45z6aztLGqWxWgkQ+zwdhEeHiw7y/tzoHQg3ffZlp7YmO4IM+xaX1ppiSRSFxoH/lzZN2MAEmHd3ii2+pnHPCPx+MjoyGejwky2TZs0nRMUAhBwgFIa8rSGgGM+mIJvrfa7EUFHovFsqobFimbFTq6/R390f/5ipnXraoNxXxThdS0tR5MjkvA83x798CYxA2JFhspeVmt0KzW11Xda3FoeTKZlCQpEpcMXcMwA+CU00abTCaoqdlsXhuxAOWyS8/NroGrt4Rz3S4Mm9/IK9eGreM8pRutjzRtgpNWq7Vp8/poNCqKIkFQLGuz2+93i4JlknQwXustjJRdSibCsaEAf67bvbDFAzGmpU8lTf2N9eVwkiCIqeG0EFOg47JLSU93759anYtZQ6vfMh7ig6thBEKk7KrnelvvxV6rrC62Sf/c5uzt6UHtiRKD7BKLxZIKXVvp2Fh9+1JUVWUNjGwflCgSVBfR5IyxtDELi+fZCUUzRsOqpBiD4wqctLDpMwi6YYymyFu9w9WVxahhkbJZy2JDPMtx2+rNUNDp5U9us4R51WUlybnPZ2HrS02qhrV0paqKaI8toyx2oxfE4wOoVVFikEUisaQop4U7evTo9AHgv7x4Ps9O4vjs8n379oVCocwo21Mr6ezs/OlPf5pKpWB2gRsSalWkbBbRlFTqzvmnc+fOZQZ5DQaD0MgvvjiPgxnlkFOnTt3/aEA4SQqCgBoWKZsVVFXFsNsjtmZQVCMQUpxO9+HDh8+cObOAdYaTFFIWKZst0kO8SzMuT0nJxvkbfCSheTwenuczw7Ts3r171mCa91lnkKfC0SRqW9T9ys7fPY6TuK4+aDaYGMwaD/5+PwxhUCQKKCjKZgeWZS20PKOEBjvrLXYzAdPZ9FCE7NwXx2RisCim8uwEQ93OKwwDkxXDxsg2K4faFimbFQiC0DGSJr8ejoUiQZGHjkVDsPu1Z8+eey0IlR0aGvIPD64rpC0s/uGHH0K/aRMTF/Q8q5LjA8AjZVe5tSTDUreVncpZoZGw+wWTgczVctNz2cxzjtxu95EjRw4cOJAp8fv9r776apjX+gKSlVHvFZsfctDFh0vD4NBIVGTWVzhnnUrQdQx2wmCGMOepBEWDOSs2fQEYX//ckrjeHfn+lsT2xo2oYVH3K1u4XXbeH+8aluk7Kamm6QnRaO2TCBxrrGanyqfDCxp01OsgGRrXdGM8ol64KfQGlM3Fis/rQq2KlM0iZrMZx8KfXxq4Nnz7+fCCIEwloxdupr75qlxmZUuZWFpchVp17sRgYmICtcJS0dnjP3nZFhUWFQh+uCNYXpJv4SjUnnNHWfSouqXshNGcpt363VfeWVH2m7NrXbzA5ysvLUANi44YLAdOG1dSXLCnLrKwxTcUJGqKQG1VIWpJlMsuHxWl3vThLUvg918x83ro23dqo1UFeGNDLWpDpOxyU16SZ7NxOOhsGwE3/A8eqLDALj2+IezOK6qp8KHWQ8quDC672WwymjfSFd5o7zgZSlChJDX9HhuAGW6L4jYrLotRV6Ru3bQ5958Rh5Rd+2xeX1ZZklg3Fg5Fk0CPqDqIJKmYQBS7ZTOlyLrJbjP7PNZV1PVByq59LBZLNXxNvpdlWRAETdMyw8ihxkHK5jr0JKgdFgk6yIVAyiIQSFkEAimLQMoiEEhZBAIpi0DKIhBIWQQCKYtAyiIQSFkE4puAHlWHWG3KoqE3ssSlS5eamppQw6LEAIFyWQQCKYtAIGURCKQsAimLQCBlEQikLAIpi0AgZREIpCxirYBGi3kYUWYy+ewxkZoJQRBIWcQKE4vFIuEJPh7RdJ3CFQKkSJAksRijjOgpWxLYVcOsYWZVZykKGIB1Oj12pzfXnuWElF37hCGhsVg8aaFCZqy1lOwjsBkPdFYJ9e6hQkUjnx8vnxitNHCzw+HK85XmiLtI2bVMKDQ+PDTgoLoteo+P6QPYPC40ZcAoQ43mYRcVw5aMr/Mn12OUr7i0mmEYpCwiKznA8GCPCRsuI0+TMKYuoptNgbiDuIJhV3ip6lbHd612T3FJxQoO4IyUXWtomtbb3aZLgXxw2oRHlnDNVrwbvmKJza03dvl8BQWFJUhZxGJJJBK3ujqKqRMsMZqlTdjx63b6eiz8SBe/q6Z28/J/R/SourUDH48lYwPF+G+XZ3NJvXIC+7uCwtJlPhyG7v3KFst879dA/y2Nb/Xif1zAsqqqLiw3VQzzgPLCuqpaq9W2bN8Unf1aC/gH2wH/2cJ8XQwUSFbR/zbQc0VMxZGyiG9Kf1+XFv3chV9cqQqUU//e03VVEASkLOLBjI8F9MR1F/HlylajjPxte/vN5UkykbKrur8VD411ePGPc6Ey5fT7ba2XkbKI+/WZurs7SohjOVIfEx5xYZ/1dN9EyiLmpq+nvZT6r5yqkg2/SUhtwWAQKYuYTTgcxuRhEx7KtYo5jTPDQ/1IWcRshof6POBUDlaMAJKD7BwNjCBlEV8zMT5mxvsowOdm9Tz4p/6RAFIWMS3E+oc84C+5XMM8+nL20gOk7KoLsQE3eY0Aci5X0oVfSMSGVFVFyiKwUHCMwXpzv56EHorH40jZhx1N01KiwuGB3K+qGWuPhseysWZ0vexqIhqNcsRIQiuPqsWC7gCYkUf1MfiECQQByK0r8ix4/1g8iZR9qLnVOxgJB2W9uEMujyjEhExaSd1J1bgpxUHpmh6qYM9y+EiO1BYHCkPGeJ63Wq1I2YcOfzDuH+i5EC8Z4CtxI4zdCahj0rSoRtiaXR4nOVjH/TFHqm3G2qKRSqTsQ0d79+BAKHU2vlHSgGoI9D0SgIRGfDLhqDGzKlZYxXzE4LfPmhLmDYS5FgAKvjd0URMHCLYCADo9aciGEsZNhYypCABclyfUeIuWaE1rYX8UZ0oAhsN5VP66nlpIh4/BRiPJKEoMHi5a2vquhpgusWjSMA3D9PvP35U0DaWoPZ5/rGVP2Mh074ewbKDdj2OTjmJaUol/RdkfxfDJEQkMNf3CmTtyr6fs25XIWYW/Rnv24UzZ5DwaIB2SNILp4rzdAoIsa0uv7KVLl1bRTzgwMLCKarvItk1p+PW462bCgt0ZKQPHVN14gLVJHfvjqMNcvL9UfgvHFFxRaAM7+vOje/bs2fVoQ/qeGQP7z+PH4ZyHDv0wJSqvvPLSu+++CycbGho++OCDmqpmncgDlKezs/PIkSNvv/22natQQL4izPsSLR2TZWAsuWDkank2FfaQ3fsF89cbPYF+vZjjbpcoimKoAg6+0XHJv4aszc4XN5v/g6QoDNwuBACQJAnA1FzgxIkTjz322DvvvAMn7jj6ry57JSC4lpaWDRs2dHR0NO9sMrs2y1r/QjphEra5YcvS3s+IjsvmapdroOdsvGJ6iZGOrzP2s3aG+MEmz+4K+92Lj0nUoOgekbbdfyu9vb3l5eWZ97W1te+//77b7YG+hkLhs2fPHjhw4MyZMylJJ8w1gPYtJCLiMvxLQ7ns2qerb/BivGRzAVntBgTAHAxG4CAQpxOiFWC3o+5EUiFxrMzJ1Hk5J0d2jsMADCrcDDEZRQVFuz5CFcoNRQpP33tDL7/88qFDhz755JOnnnrq+PHjbrd7MviSMLjC6FtTUwOnLl++smvHJtJco8jzPjVgwuOyLC/tmEhI2VwkFg6NKvnb7aAhP61shmIb/LG+PmBkYJik6gyZ3k9+e52j3MWMxuVtJTZicscZE9VgUvEnbdWibL73hqCjp06dymQFe/fu3bFjx5tvvgknT548+eKLL8I3MAOGgba5eQfB1Sixr+bbCVMNGseXeE+OEoOcQxRFySBV7Hb+d/To0fPnz6dSqZdeeglM4+dHj0JfM+VwniK7Cb5g2pqZP7NsRCFGeA6mFJWVlf39/RggcDof/nv3RmFWcOHCBZvNNjjJ6dOn6+rq4FZ279790UcfdXZ249w6gqua73dRDYaiKKTsGgdaGJTnGBYT+gT318YkgiD4/f6MmrC8ra2t51ZXscNEgBmLQGUVJX1sFSasMDdNSQZhrguF+WPHjsGSjO5TfkOsVivs4H744Ye//vWvjTv85Cc/gV0xnHIR5tp5K6vTSNm1z1gkGVG5eS1y8ODB9957Dyo4qxwqSxpAl0abm5thbspxHAycUMrnn3++uXkXy9Cvv/46jMqZsL1z587nnnsuGAzyPN/Y2KiLQ9Lo+4Ya37dvH9Qdik5w1bip+JvXSjNo+BeEEoO1D+xjB9U58s94PJ7ZWUOgfEVFRVDEzEewvKGh4cSJE3ctBMKKGh/70pDHYDdrKnDC97roV/lrbicHc9lM4dWrV2sneeONN6DNWqpfS3bpcgDmu++88w78FzcVEObq+WQFHEWCJW8f1P3KRcyEPKHOnRhApeCuHO7ZX3311ekjXezfv/+1117btm32US0rSYDkxdRgF+XcjTOlAKcMXdZSvUr4c0OZICz16ZNhlBvHaYyAfycAU3kDyqYJKn9ZFwfUWAumqxg+6YmhYWAee3nNYFiGRMqufVw2zjkh9GOue80Agyvsxf/iF7/4l8OHpwpZloV9/I8/njEMB4PrBNBIIOiSII3+bg6rEq3wdZ9h5JTwp/C1sC8i6KWcxbXk7YMSg5zDbuEcZOpen0qqoeoGTDrPnTvX1dk5q9efSCR+9rOfTZU4KU3Tkyv1RRJYrd3hQcqufWCe6qbuqWxMNLqDqeqa2hdeeOHNN9+c6nKFBTWl6C+//PJTTz01XVkHObwi30IxLDpm5jhuydeMxpfNFou5xqDlRtcfRkuermMeKQazjluNJfTPu0PfqXLkWWaklcMxaZxXGoosmfljonqyNWgW/Dsdf7IRD7h0cMHjy96HiFqv254uq1iPctmHgqoS705heDy5rieMUTiwMwZNgLiEiSo2zmt9Ed3UH1ufb84zUyYSBwCTVWOMl/82AHtORomDsZqIoagEVLmEjT/Q1yyRxGoLXIXZWDNSNhdxOBx51sjfxkLnB2d3XzTNUGUwzsc+743dvWBPKLXexzUVW6/4E7X4RA373ytSf00nMNwOycbKUS6bo2zbULHdMkyC2ZdIEwRhYKxu3DPWtI8JpzrCDmXcRlwmQWplUjj9uy5vRZZWjpTNXSoqq55w9NxdTtEmFbvfDVVOgy+kR8uZCyvV8UoaVV5fEVL2ocPjtG6pLXvW1eoik7MCLQYo3Zj7qP4jDn6LfXgj97sV6yVr3ykqLs/e+lEum9M4bVzT5vVYW09P0nJd+Lo3Q9OMLNlobMZgnW5K/ZY7YSeulDNfrFSFRd0t4yVujxcp+/BC0/TOret9Q4GSid5hwRRRuYjG8hiD46Su0wwuOmnNSWl2Qizj4jXsRyQQVrC2ceyRktKqrG4CPapu1SBJUkKQwkkFaDJhKEHNagVJGsiakeBAwEX2WfGula1hSH8Ms2y3O4uzqyw6lZAlsvqoOl3XBUHAcbyz40a16d1Frm1JTiXwWo3A7FtXsyXbDYu6X6sSKKvFYuE4rqq6bkg9tPJ7AN0ZwvYug69I2VWP1Wp3+eoC2jMrW41++eDGTduWZ1uo+7Xq8eUXMSYyMEwV4Ctwrks2nP3SwcbGJgDA8mwRRdm1gN3pcxVsH1D/eZm3m8A2+PVDW7Y2LpuvKMquHdyePJYzt7cz5aYPTSC4DFsM6d9VmKZN1RuW+ZsiZdcOsDcGd9A3Wwmb8YUTz+JQa7Jui+J7GNeWsqLS5f+aSNk1BdxBb9y0dXjY0T2xPY88b8dvLO36NcMU1B8XsPKSokqHw7ki3xEpuwYpLq7Izy8ZHnL0xXZ4iM+sePeSrHZCfzym1hQXl67L867gt0PKrk1IkiyvqBFF0T/kSMjjpD5owdpZfHS+69ENMqFXJLF6BfhceaXwT2Hlvxr6ddcwDMOsq16fSpXHYrWhcIMoSRbSb9avm/AQCQQcaPfa+2sYm9TKElhtSnM7bBa3y+d0OpfzsABS9qGGnSQ/P19V1Wi0IhatDSYFRTUA0ElcIrEEqQd0w65iNs3gVJ3GcczCESabo9iZt+RPOkDKIuaXLXgmyUxCg5VJIpGIzWaj7rDkQxItLf8vwADJILLWijEuZgAAAABJRU5ErkJggg==',
			),
			array(
				'id'    => 'steppedarea',
				'name'  => __( 'Stepped Area', 'jet-engine' ),
				'image' => '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',
			),
			array(
				'id'    => 'candlestick',
				'name'  => __( 'Candlestick', 'jet-engine' ),
				'image' => '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',
			),
			array(
				'id'    => 'histogram',
				'name'  => __( 'Histogram', 'jet-engine' ),
				'image' => 'iVBORw0KGgoAAAANSUhEUgAAAOYAAACRCAIAAABYL1OVAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6NTAxNDNGRTZEODI0MTFFQkI0MkFBMDJEN0Y2REU3MTAiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6NTAxNDNGRTdEODI0MTFFQkI0MkFBMDJEN0Y2REU3MTAiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo1MDE0M0ZFNEQ4MjQxMUVCQjQyQUEwMkQ3RjZERTcxMCIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo1MDE0M0ZFNUQ4MjQxMUVCQjQyQUEwMkQ3RjZERTcxMCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PmR+6poAAAHDSURBVHja7NyxbQJBEEDR24uIbMduAbKrwXRgOULUhogQHZgWNjRVTGI3wCKRQmI4rF38XgGn0+gHk+ykUkrHnW2+Dtv94ZYvvE/7j1m/+vxe735u+c7i7Xk5f2l6mL2ekCxIFiSLZEGyIFkkC5IFySJZkCxIFsmCZEGySBYkC5LlP0gRYQq0lOxDPlcc63lgbf/juaLFAMmCZEGySBYkC5JFsiBZkCySBcmCZJEsSBYki2RBsiBZJAuSBckiWahbyjmbAi0l6/TGRWOduuhO1y4mr09Ob1gMsMuCZEGySBYkC5IFySJZkCxIFsmCZEGySBYkC5JFsiBZkCySBcnCNVJEmAItJeuOwUXuGFgMQLJIFiQLkkWyIFmQLEgWyYJkQbJIFiQLkkWyIFmQLJIFyYJkkSxIFn4v5ZxNgZaSre30xijXJeo5ddHVd3pjrJ+xGIBkkSxIFiSLZEGyIFkkC5IFySJZkCxIFsmCZEGySNYIkCxIFiSLZEGycCZFhCnQUrKllAe7duH0xt/8jMUAJItkQbIgWSQLkgXJIlmQLEgWyYJkQbJIFiQLkkWyRoBkQbIgWSQLkoUzaRgGU6AhRwEGAHtzp6mcCSMsAAAAAElFTkSuQmCC',
			),
			array(
				'id'    => 'columns',
				'name'  => __( 'Columns', 'jet-engine' ),
				'image' => 'iVBORw0KGgoAAAANSUhEUgAAAOYAAACRCAIAAABYL1OVAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MjY1MTdCRjZEODI0MTFFQkE2RURCRTAwMzRDM0RCMTYiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MjY1MTdCRjdEODI0MTFFQkE2RURCRTAwMzRDM0RCMTYiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNjUxN0JGNEQ4MjQxMUVCQTZFREJFMDAzNEMzREIxNiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDoyNjUxN0JGNUQ4MjQxMUVCQTZFREJFMDAzNEMzREIxNiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PhrI2XEAAAGqSURBVHja7NyxCcJAGIDRi6R2BYcIVraOIDiJUziJ4Ai2Vk7hCtbC2WgVhIuReOe9V6eQ5PMnCXdpYowByjFzCpAsSBYki2RBsiBZJAuSBckiWZAsSBbJgmRBskgWJAuSpQZtuT99vbumH3zaL1xsUxYkC5JFsiBZkCySBcmCZJEsSBZGaJ2CbG0O9/SDj9taLqUpi2RBsiBZJAuShb7nm5FBm1KCfSmYsiBZJAuSBckiWZAsSBbJgmRhPLsSeCvPb0uasrgxAMmCZJEsSBb6KnrJ5UsWpixIFiSLZEGyIFkkC5IFySJZkCxIFsmCZEGySBYkC5KlZp9vF7EvhcKSJTe3yyr94Pny7MYAJAuSRbLg8etP5fm5VlMWJAuSRbIgWZAskoWpeS/LzwxaxxNeS3lMWUzZb/ylyl0aV7NpllC7MfAf8/gFkgXJIlmQLEgWyYJkQbJIFiQLkkWyIFmQLJIFyYJkkSxIFiSLZEGyIFkkC5IFySJZkCxIFiSLZEGyIFkkC5IFySJZkCxIFsmCZEGySBYkC5JFsiBZkCyShWw1Xdc5CxTkIcAA3FMozV12WSgAAAAASUVORK5CYII=',
			),
			array(
				'id'    => 'scatter',
				'name'  => __( 'Scatter', 'jet-engine' ),
				'image' => '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',
			),
			array(
				'id'    => 'geo',
				'name'  => __( 'Geo', 'jet-engine' ),
				'image' => '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',
			),
		) );
	}

	public function get_legend_options() {
		return array(
			array(
				'value' => 'right',
				'label' => __( 'To the right of the chart', 'jet-engine' ),
			),
			array(
				'value' => 'bottom',
				'label' => __( 'Below the chart', 'jet-engine' ),
			),
			array(
				'value' => 'left',
				'label' => __( 'To the left of the chart', 'jet-engine' ),
			),
			array(
				'value' => 'in',
				'label' => __( 'Inside the chart, by the top left corner', 'jet-engine' ),
			),
			array(
				'value' => 'top',
				'label' => __( 'Above the chart', 'jet-engine' ),
			),
			array(
				'value' => 'none',
				'label' => __( 'No legend is displayed', 'jet-engine' ),
			),
		);
	}

	public function get_check_list() {
		return array(
			array(
				'field' => 'query_id',
				'label' => __( 'Select query to get data from', 'jet-engine' ),
			),
			array(
				'field' => 'type',
				'label' => __( 'Select type of the chart in Chart Type tab', 'jet-engine' ),
			),
			array(
				'field' => 'columns',
				'label' => __( 'Select columns which will be dispalyed in the chart', 'jet-engine' ),
			),
		);
	}

	/**
	 * Register add controls
	 * @return [type] [description]
	 */
	public function page_specific_assets() {

		$module_data = jet_engine()->framework->get_included_module_data( 'cherry-x-vue-ui.php' );

		$ui = new \CX_Vue_UI( $module_data );

		$ui->enqueue_assets();

		Chart::enqueue_charts_js();

		wp_enqueue_script(
			'jet-engine-chart-delete-dialog',
			JET_ENGINE_DYNAMIC_CHARTS_URL . 'assets/js/admin/delete-dialog.js',
			array( 'cx-vue-ui', 'wp-api-fetch' ),
			JET_ENGINE_DYNAMIC_CHARTS_VERSION,
			true
		);

		wp_localize_script(
			'jet-engine-chart-delete-dialog',
			'JetEngineChartsDeleteDialog',
			array(
				'api_path' => jet_engine()->api->get_route( 'delete-item' ),
				'redirect' => $this->manager->get_page_link( 'list' ),
				'instance' => Dashboard::instance()->instance_slug(),
			)
		);

		wp_enqueue_style(
			'jet-engine-chart-admin',
			JET_ENGINE_DYNAMIC_CHARTS_URL . 'assets/css/admin.css',
			array(),
			JET_ENGINE_DYNAMIC_CHARTS_VERSION
		);

		wp_enqueue_script(
			'jet-engine-chart-edit',
			JET_ENGINE_DYNAMIC_CHARTS_URL . 'assets/js/admin/edit.js',
			array( 'cx-vue-ui', 'wp-api-fetch' ),
			JET_ENGINE_DYNAMIC_CHARTS_VERSION,
			true
		);

		do_action( 'jet-engine/chart-builder/editor/after-enqueue-scripts' );

		$id = $this->item_id();

		if ( $id ) {
			$button_label = __( 'Update Chart', 'jet-engine' );
			$redirect     = false;
		} else {
			$button_label = __( 'Create Chart', 'jet-engine' );
			$redirect     = $this->manager->get_edit_item_link( '%id%' );
		}

		wp_localize_script(
			'jet-engine-chart-edit',
			'JetEngineChartConfig',
			$this->manager->get_admin_page_config( array(
				'api_path_edit'           => jet_engine()->api->get_route( $this->get_slug() . '-item' ),
				'api_path_search_preview' => jet_engine()->api->get_route( 'search-chart-preview' ),
				'api_path_fetch_data'     => jet_engine()->api->get_route( 'chart-fetch-data' ),
				'queries'                 => Query_Builder::instance()->get_queries_for_options( true ),
				'object_fields'           => jet_engine()->listings->data->get_object_fields( 'blocks', 'options' ),
				'legend_options'          => $this->get_legend_options(),
				'checklist'               => $this->get_check_list(),
				'types'                   => $this->get_chart_types(),
				'data_sources'            => array(
					'fetched' => __( 'Fetched Column', 'jet-engine' ),
					'object'  => __( 'Post/Term/User/Object Field', 'jet-engine' ),
				),
				'locale'                  => Plugin::instance()->get_locale(),
				'item_id'                 => $id,
				'edit_button_label'       => $button_label,
				'redirect'                => $redirect,
				'help_links'              => array(
					array(
						'url'   => 'https://crocoblock.com/knowledge-base/articles/jetengine-charts-builder-overview/?utm_source=jetengine&utm_medium=chart-builder&utm_campaign=need-help',
						'label' => __( 'Chart Builder knowledge base', 'jet-engine' ),
					),
				),
			) )
		);

		add_action( 'admin_footer', array( $this, 'add_page_template' ) );

	}

	/**
	 * Print add/edit page template
	 */
	public function add_page_template() {

		ob_start();
		include JET_ENGINE_DYNAMIC_CHARTS_PATH . 'templates/edit.php';
		$content = ob_get_clean();
		printf( '<script type="text/x-template" id="jet-chart-form">%s</script>', $content );

		ob_start();
		include JET_ENGINE_DYNAMIC_CHARTS_PATH . 'templates/columns.php';
		$content = ob_get_clean();
		printf( '<script type="text/x-template" id="jet-charts-columns">%s</script>', $content );

		ob_start();
		include JET_ENGINE_DYNAMIC_CHARTS_PATH . 'templates/delete-dialog.php';
		$content = ob_get_clean();
		printf( '<script type="text/x-template" id="jet-charts-delete-dialog">%s</script>', $content );

	}

	/**
	 * Renderer callback
	 *
	 * @return void
	 */
	public function render_page() {
		?>
		<br>
		<div id="jet_chart_form"></div>
		<?php
	}

}
